/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.notenoughanimations.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.tr7zw.notenoughanimations.NEAnimationsLoader;
import dev.tr7zw.notenoughanimations.config.Config;
import dev.tr7zw.transliterationlib.api.TRansliterationLib;
import dev.tr7zw.transliterationlib.api.config.ConfigBuilder;
import dev.tr7zw.transliterationlib.api.config.WrappedConfigEntry;
import dev.tr7zw.transliterationlib.api.wrapper.WrappedScreen;
import java.util.function.Consumer;

public abstract class SharedConfigBuilder {
    protected static Gson gson = new GsonBuilder().setPrettyPrinting().create();

    public WrappedScreen createConfigScreen(WrappedScreen parentScreen) {
        Config config = NEAnimationsLoader.config;
        ConfigBuilder builder = TRansliterationLib.transliteration.getNewConfigBuilder();
        builder.setParentScreen(parentScreen).setTitle(TRansliterationLib.transliteration.getWrapper().getTranslateableText("text.notenoughanimations.title"));
        ConfigBuilder.ConfigEntryBuilder entryBuilder = builder.entryBuilder();
        ConfigBuilder.ConfigEntryBuilder.ConfigCategory category = builder.getOrCreateCategory(TRansliterationLib.transliteration.getWrapper().getTranslateableText("category.notenoughanimations"));
        this.setupAnimationConfig(entryBuilder, category, config);
        builder.setSavingRunnable(() -> NEAnimationsLoader.INSTANCE.writeConfig());
        builder.setTransparentBackground(true);
        return builder.build();
    }

    public void setupAnimationConfig(ConfigBuilder.ConfigEntryBuilder entryBuilder, ConfigBuilder.ConfigEntryBuilder.ConfigCategory category, Config config) {
        this.addEntry(category, this.createBooleanSetting(entryBuilder, "notenoughanimations.enableAnimationSmoothing", config.enableAnimationSmoothing, true, n -> {
            config.enableAnimationSmoothing = n;
        }));
        this.addEntry(category, this.createBooleanSetting(entryBuilder, "notenoughanimations.enableInWorldMapRendering", config.enableInWorldMapRendering, true, n -> {
            config.enableInWorldMapRendering = n;
        }));
        this.addEntry(category, this.createBooleanSetting(entryBuilder, "notenoughanimations.enableOffhandHiding", config.enableOffhandHiding, true, n -> {
            config.enableOffhandHiding = n;
        }));
        this.addEntry(category, this.createBooleanSetting(entryBuilder, "notenoughanimations.enableRotationLocking", config.enableRotationLocking, true, n -> {
            config.enableRotationLocking = n;
        }));
        this.addEntry(category, this.createIntSetting(entryBuilder, "notenoughanimations.animationSmoothingSpeed", (int)config.animationSmoothingSpeed, 20, 5, 100, n -> {
            config.animationSmoothingSpeed = n.intValue();
        }));
    }

    public <T extends Enum<?>> WrappedConfigEntry createEnumSetting(ConfigBuilder.ConfigEntryBuilder entryBuilder, String id, Class<T> type, T value, T def, Consumer<T> save) {
        return entryBuilder.startEnumSelector(TRansliterationLib.transliteration.getWrapper().getTranslateableText("text.notenoughanimations.option." + id), type, value).setDefaultValue(def).setTooltip(TRansliterationLib.transliteration.getWrapper().getTranslateableText("text.notenoughanimations.option." + id + ".@Tooltip")).setSaveConsumer(save).setEnumNameProvider(en -> TRansliterationLib.transliteration.getWrapper().getTranslateableText("text.notenoughanimations.option." + id + "." + en.name())).build();
    }

    public WrappedConfigEntry createBooleanSetting(ConfigBuilder.ConfigEntryBuilder entryBuilder, String id, Boolean value, Boolean def, Consumer<Boolean> save) {
        return entryBuilder.startBooleanToggle(TRansliterationLib.transliteration.getWrapper().getTranslateableText("text.notenoughanimations.option." + id), value).setDefaultValue(def).setTooltip(TRansliterationLib.transliteration.getWrapper().getTranslateableText("text.notenoughanimations.option." + id + ".@Tooltip")).setSaveConsumer(save).build();
    }

    public WrappedConfigEntry createIntSetting(ConfigBuilder.ConfigEntryBuilder entryBuilder, String id, Integer value, Integer def, Integer min, Integer max, Consumer<Integer> save) {
        return entryBuilder.startIntSlider(TRansliterationLib.transliteration.getWrapper().getTranslateableText("text.notenoughanimations.option." + id), value, min, max).setDefaultValue(def).setTooltip(TRansliterationLib.transliteration.getWrapper().getTranslateableText("text.notenoughanimations.option." + id + ".@Tooltip")).setSaveConsumer(save).build();
    }

    public abstract WrappedConfigEntry getPreviewEntry();

    public void addEntry(ConfigBuilder.ConfigEntryBuilder.ConfigCategory category, WrappedConfigEntry entry) {
        category.addEntry(entry);
    }
}

